<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for parts
*
* @package	vbsignatures
*/
class vBSignatures_DataManager_Part extends vB_DataManager
{
	/**
	* Array of recognised and required fields for parts, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'partid' 			=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'title' 			=> array(TYPE_STR, 		REQ_YES, 	VF_METHOD),
		'active' 			=> array(TYPE_STR, 		REQ_NO, 	VF_METHOD, 	'verify_onoff'),
		'categoryid' 		=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD),
		'signaturestyleid' 	=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD),
		'layerid' 			=> array(TYPE_UINT, 	REQ_YES, 	VF_METHOD),
		'displayorder' 		=> array(TYPE_UINT, 	REQ_NO),
		'price' 			=> array(TYPE_UINT, 	REQ_NO),
		'filename' 			=> array(TYPE_STR, 		REQ_YES),
		'permissions' 		=> array(TYPE_NOCLEAN, 	REQ_NO, 	VF_METHOD, 	'verify_serialized'),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_vbsignatures_part';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('partid = %1$d', 'partid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vBSignatures_DataManager_Part(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('dbtech_vbsignatures_partdata_start')) ? eval($hook) : false;
	}

	/**
	* Verifies that the title is valid
	*
	* @param	string	Title of the part
	*
	* @return	boolean
	*/
	function verify_title(&$title)
	{
		global $vbphrase;
		
		$title = strval($title);
		if ($title === '')
		{
			// Invalid
			return false;
		}
		
		/*
		// Check for existing part of this name
		if ($existing = $this->registry->db->query_first("
			SELECT `title`
			FROM `" . TABLE_PREFIX . "dbtech_vbsignatures_part`
			WHERE `title` = " . $this->registry->db->sql_prepare($title) . "
				" . ($this->existing['partid'] ? "AND `partid` != " . $this->registry->db->sql_prepare($this->existing['partid']) : '') . "			
			LIMIT 1
		"))
		{
			// Whoopsie, exists
			$this->error('dbtech_vbsignatures_x_already_exists_y', $vbphrase['dbtech_vbsignatures_part'], $title);
			return false;
		}
		*/
		
		return true;
	}

	/**
	* Verifies that the onoff flag is valid
	*
	* @param	string	On/Off flag
	*
	* @return	boolean
	*/
	function verify_onoff(&$onoff)
	{
		// Validate onoff
		$onoff = (!in_array($onoff, array('0', '1')) ? '1' : $onoff);
		
		return true;
	}

	/**
	* Verifies that the categoryid is valid
	*
	* @param	string	categoryid
	*
	* @return	boolean
	*/
	function verify_categoryid(&$categoryid)
	{
		// Validate speciesid
		return is_array(VBSIGNATURES::$cache['category'][$categoryid]);
	}

	/**
	* Verifies that the styleid is valid
	*
	* @param	string	styleid
	*
	* @return	boolean
	*/
	function verify_signaturestyleid(&$signaturestyleid)
	{
		// Validate speciesid
		return is_array(VBSIGNATURES::$cache['signaturestyle'][$signaturestyleid]);
	}

	/**
	* Verifies that the layerid is valid
	*
	* @param	string	layerid
	*
	* @return	boolean
	*/
	function verify_layerid(&$layerid)
	{
		// Validate speciesid
		return is_array(VBSIGNATURES::$cache['layer'][$layerid]);
	}

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		
		if (!file_exists(DIR . '/dbtech/vbsignatures/images/parts/' . VBSIGNATURES::$cache['layer'][$this->fetch_field('layerid')]['folder'] . '/' . $this->fetch_field('filename')))
		{
			$this->error('dbtech_vbsignatures_invalid_x_y', $vbphrase['dbtech_vbsignatures_part'], (DIR . '/dbtech/vbsignatures/images/parts/' . VBSIGNATURES::$cache['layer'][$this->fetch_field('layerid')]['folder'] . '/' . $this->fetch_field('filename')));		
			return false;
		}

		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbsignatures_partdata_presave')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}
	
	/**
	* Additional data to update before a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function pre_delete($doquery = true)
	{
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbsignatures_partdata_predelete')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbsignatures_partdata_postsave')) ? eval($hook) : false;

		// Rebuild the cache
		VBSIGNATURES_CACHE::build_cache('part', '
			LEFT JOIN ' . TABLE_PREFIX . 'dbtech_vbsignatures_signaturestyle AS style ON (style.signaturestyleid = dbtech_vbsignatures_part.signaturestyleid)
			LEFT JOIN ' . TABLE_PREFIX . 'dbtech_vbsignatures_category AS category ON (category.categoryid = dbtech_vbsignatures_part.categoryid)
			ORDER BY style.displayorder, category.displayorder, dbtech_vbsignatures_part.displayorder ASC
		');
		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbsignatures_partdata_delete')) ? eval($hook) : false;
		
		// Rebuild the cache
		VBSIGNATURES_CACHE::build_cache('part', '
			LEFT JOIN ' . TABLE_PREFIX . 'dbtech_vbsignatures_signaturestyle AS style ON (style.signaturestyleid = dbtech_vbsignatures_part.signaturestyleid)
			LEFT JOIN ' . TABLE_PREFIX . 'dbtech_vbsignatures_category AS category ON (category.categoryid = dbtech_vbsignatures_part.categoryid)
			ORDER BY style.displayorder, category.displayorder, dbtech_vbsignatures_part.displayorder ASC
		');
		return true;
	}
}


/*======================================================================*\
|| ####################################################################
|| # Created: 16:52, Sat Dec 26th 2009
|| # SVN: $ $Rev$ $ - $ $Date$ $
|| ####################################################################
\*======================================================================*/